<?php
namespace lib;

abstract class Lang
{
	private static $loaded = array(), $container = array();
	
	public static function load($file)
	{
		if(!in_array($file, self::$loaded))
		{
			$load = \Pawn::config('lang/'.\Pawn::setting('locale').'/'.$file.'.yml');
			
			\Pawn::merge(self::$container, $load);
			
			self::$loaded[] = $file;
		}
	}
	
	public static function get()
	{
		$keys = func_get_args();
		
		$response = self::$container;
		
		foreach($keys as $key)
		{
			if(is_numeric($key))
			{
				if(is_array($response))
				{
					return isset($response[$key])?$response[$key]:str_replace('{n}', $key, $response['n']);
				} else
				{
					return str_replace('{n}', $key, $response);
				}
			} elseif(is_array($key))
			{
				if(is_array($response))
				{
					foreach($key as $find=>$replace)
					{
						if(isset($response[$find]))
						{
							$response['format'] = str_replace('{'.$find.'}', isset($response[$find][$replace])?$response[$find][$replace]:str_replace('{n}', $replace, $response[$find]['n']), $response['format']);
						} else
						{
							$response['format'] = str_replace('{'.$find.'}', $replace, $response['format']);
						}
					}
					
					return $response['format'];
				} else
				{
					foreach($key as $find=>$replace)
					{
						$response = preg_replace_callback('/\{'.$find.'(:(.*))?\}/U', function($match) use($replace) {
						  return str_replace('{value}', $match[0], $replace);
						}, $response);
					}
				}
				
				return $response;
			} elseif(!is_array($response))
			{
				return $response;
			} elseif(!isset($response[$key]))
			{
				return false;
			}
			
			$response = $response[$key];
		}
		
		return $response;
	}
	
	public static function find()
	{
		$keys = func_get_args();
		
		$response = self::$container;
		
		foreach($keys as $i=>$key)
		{
			if(!isset($response[$key]) || !is_array($response))
			{
				array_splice($keys, sizeof($keys) - 2, 1);
				
				return count($keys)?call_user_func_array(array('self', 'find'), $keys):$key;
			}
			
			$response = $response[$key];
		}
		
		return $response;
	}
	
	public static function get_date($format, $time=false)
	{
		if($time === false)
		{
			$time = time();
		}
		
		return date(strtr($format, array('M'=>self::slashes(self::get('month_short', date('n', $time) - 1)))), $time);
	}
	
	private static function slashes($string)
	{
		$return = '';
		$length = strlen($string);
		
		for($i=0; $i<$length; $i++)
		{
			$return .= '\\'.$string{$i};
		}
		
		return $return;
	}
}

# Autoload
global $autoload;

if(isset($autoload['Lang']))
{
	foreach($autoload['Lang'] as $file)
	{
		Lang::load($file);
	}
}